﻿//+------------------------------------------------------------------+
//|                                            Adaptive Forecast.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Binomial transform"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input uchar Difference=5,
            LearningSpeed=1;

struct func {double d[];double c;int size;};
func array[];
int size,speed;
double buffer[],data[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   PlotIndexSetInteger(0,PLOT_SHIFT,1);
   ArraySetAsSeries(buffer,true);

   size=MathMax(1,Difference)+1;
   speed=MathMax(1,LearningSpeed);
   ArrayResize(array,size);
   ArrayResize(data,size);

   int s=1;
   double a[];
   ArrayResize(a,s,size);
   a[0]=1;

   for(int i=0;i<size;i++)
     {
      ArrayResize(array[i].d,s);
      ArrayCopy(array[i].d,a);
      array[i].c=1./(i+1);
      array[i].size=s;
      FiniteDifference(a,s);
     }

   ArrayFree(a);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int32_t rates_total,
                const int32_t prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int32_t &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);
      int bars=prev_calculated>0? rates_total-prev_calculated-1:rates_total-size-2;

      for(int i=bars;i>=0;i--)
        {
         //рассчитываем текущую ошибку
         double error=0,denom=speed;
         for(int j=0;j<size;j++)
           {
            data[j]=0;
            for(int k=0;k<array[j].size;k++)
               data[j]=data[j]+array[j].d[k]*open[i+k+1];

            error=error+array[j].c*data[j];
            denom=denom+data[j]*data[j];
           }

         error=(error-open[i])/denom;

         //корректируем коеффициенты
         for(int j=0;j<size;j++)
            array[j].c=array[j].c-data[j]*error;

         //строим прогноз
         double predict=0;
         for(int j=0;j<size;j++)
           {
            data[j]=0;
            for(int k=0;k<array[j].size;k++)
               data[j]=data[j]+array[j].d[k]*open[i+k];

            predict=predict+array[j].c*data[j];
           }

         buffer[i]=predict;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void FiniteDifference(double &a[],int &s)
  {
//---
   double b[];
   ArrayResize(b,s+1);
   ArrayInitialize(b,0);

   for(int i=0;i<s;i++)
      b[i]=a[i];

   for(int i=1;i<=s;i++)
      b[i]=MathRound(b[i]-a[i-1]);

   ArrayResize(a,s+1);
   ArrayCopy(a,b);
   s++;

   ArrayFree(b);
//---
  }
//+------------------------------------------------------------------+
